	PROGRAM applagsl
	USE MSIMSL
c**********************************************************************
c   FORTRAN77 code:  Example 11.5; Table 11.1
c
c   Program to apply nonlinear vector time series lag selection
c   techniques to given dataset.  Also apply tests of nonlinearity to 
c   that dataset.
c
c   File: applytot.f
c
c   The parameters are defined in the following manner:
c   nkmx = the maximum number of times series in the multivariate
c   nmx  = the maximum number of observations for the time series.
c   npmx = the maximum allowable autoregressive order.  npmx = 5.
c   nqmx = the maximum length of the full-stacking vector.
c   
c   Coded by: Jane L. Harvill and Bonnie K. Ray
c   Subprograms called: genvarn, genbvar, mvlrt, mvkeenan,vech,
c                       oritest
c**********************************************************************
c
      parameter (nkmx = 5, nmx = 2000, npmx = 10, maxwk = 71950, in = 30)
      implicit double precision (a-h, p-z)
c
      double precision x(nmx,nkmx),univar(nmx)
      double precision kendptaus(nkmx,nkmx,npmx)
      double precision kendtaus(nkmx,nkmx,npmx)
      double precision tauprobs(nkmx,nkmx,npmx)
      double precision ptauprobs(nkmx,nkmx,npmx)
      double precision r(npmx,nkmx,nkmx),rt(npmx,nkmx,nkmx)
      double precision pt(npmx,nkmx,nkmx)
      double precision wk(maxwk,nkmx+3),z(npmx,nkmx)
      character infile*50,outfile*50,outfile2*50,outfile3*50
c
c   Create interface for using program:
c
      write(*,*) " k,nob?"
      read(*,*) k,nob
      write(*,*) "Name of input file?"
      read(*,*) infile
      open(10,file=infile)
      do i = 1,nob
      read(10,*) (x(i,j), j = 1,k)
c           if (x(i,1) .lt. .01) x(i,1)=.01
      enddo
      close(10)
c
c	do i = 1,nob
c	   write(*,*) (x(i,j), j = 1,k)
c	enddo
      write(*,*) " Name of output file for test results?"
      read(*,*) outfile
      write(*,*) " Name of output file for coefficients?"
      read(*,*) outfile2
      write(*,*) " Name of output file for acf and pacf?"
      read(*,*) outfile3
      write(*,*) "  AR order for test?"
      read(*,*) np
c
c   End of user interface.  Now begin writing results to the output
c   file (outfile) specified by the user:
c
c   Opening statements:
c
      open(500,file=outfile)
      open(10,file=outfile2)
      write(500,*) "Results for Multivariate Tests of Nonlinearity"
      write(500,*)
      write(500,90) k,nob
 90   format("Number of series and number of observations:",9X,2I7)
      write(500,100)  np
 100  format(" Number of lags used in test:",19X,I7)
      write(500,*)
c
c   Write "header" to output file:
c
      write(500,120)
 120  format(10X,"Number of",39X,"Degrees of Freedom",8X,"W-L",8X,
     +	"H-Tr",8X,"P-Tr")
      write(500,130)
 130  format(X,"Test",4X,"Observations",8X,"W-L",8x,"H-Tr",6x,"P-Tr",
     +	7X,"Num.",6X,"Den.",8X,"P-value",4X,"P-value",4X,"P-value")
      write(500,140)
 140  format(" ---------------------------------------------------------
     +------------------------------------")
      write(500,*)
c
c   Conduct multivariate tests of nonlinearity. 
	call mvtsay(x,nob,k,np,u1,u2,u3,ndf1,ndf2,pvale,pvalc,pvalf)
	write(500,164) nob,u1,u2,u3,ndf1, ndf2, pvale, pvalc, pvalf
	call mvkeenan(x,nob,k,np,u1,u2,u3,ndf1,ndf2,pvale,pvalc,pvalf)
	write(500,163) nob,u1,u2,u3,ndf1,ndf2,pvale,pvalc,pvalf
	call mvlrt(x,nob,k,np,u1,u2,u3,ndf1,ndf2,pvale,pvalc,pvalf,1)
	write(500,162) nob,u1,u2,u3,ndf1,ndf2,pvale,pvalc,pvalf
 162	format(X,"LRT",6X,I6,11X,3F10.6,4X,I6,5X,I6,6X,F7.6,4X,F7.6,4X,
     +	F7.6)
 163	format(X,"MVKeen",3X,I6,11X,3F10.6,4X,I6,5X,I6,6X,F7.6,4X,F7.6,
     +	4X,F7.6)
 164	format(X,"MVTsay",3X,I6,11X,3F10.6,4X,I6,5X,I6,6X,F7.6,4X,F7.6,
     +	4X,F7.6)
c
c   Conduct Tsay's (1986) original univariate test of nonlinearity for
c   each series:
c
	do j = 1,k
	   do jj = 1,nob
	      univar(jj) = x(jj,j)
	   enddo
	   call origf(univar,nob,np,f,ndf1,ndf2,puniv)
	   write(500,170) nob,j,f,ndf1,ndf2,puniv
 170	   format(X,"Univ.",4X,I6,2X,I5,2X,F12.6,4X,I6,5X,I6,6X,F7.6)
	enddo
c
c   Conduct Semimult version of Tsay's (1986) original univariate test of nonlinearity for
c   each series:
c
	do j = 1,k
	   call semimultf(x,k,j,nob,np,f,ndf1,ndf2,puniv)
	   write(500,171) nob,j,f,ndf1,ndf2,puniv
 171	   format(X,"SM.  ",4X,I6,2X,I5,2X,F12.6,4X,I6,5X,I6,6X,F7.6)
	enddo

	call kptaus(x,nob,k,10,0.0d0,wk,z,kendtaus,tauprobs,kendptaus,
     +        ptauprobs)
	call compr(nob,10,k,x,in,r,rt)
	call mvpacf(nob,10,k,x,pt)
	do i = 1,k
	do j = 1,k
	   pt(1,i,j) = rt(1,i,j)
	enddo
	enddo
c
	open(600,file=outfile3)
	write(600,230) k
	do ilag = 1,10
	   do itsr = 1,k
	      write(600,240) ilag, nob, 
     +		   (rt(ilag,itsr,itsp),itsp=1,k),
     +		   (pt(ilag,itsr,itsp),itsp=1,k),
     +		   (r(ilag,itsr,itsp),itsp=1,k),
     +		   (kendtaus(itsr,itsp,ilag),itsp=1,k),
     +		   (tauprobs(itsr,itsp,ilag),itsp=1,k),
     +		   (kendptaus(itsr,itsp,ilag),itsp=1,k),
     +		   (ptauprobs(itsr,itsp,ilag),itsp=1,k)
	   enddo
	enddo
	close(600)
c
 230	format("lag    n     Statistics in groups of ",I1,".")
 240	format(I2,4X,I4,2X,20F8.4)
c
	stop
	end 
	
	subroutine mvtsay(x,n,k,np,u1,u2,u3,ndf1,ndf2,pvaluee,pvaluec,
     +	pvaluef)
c
c***********************************************************************
c
c   FORTRAN subroutine to calculate the value of the test statistic
c   for the multivariate extension of Tsay's (1986) test for linearity
c   of a time series.
c
c   Input: x = a matrix of dimension n x k containing the multivariate
c              time series.
c          n = an integer containing the length of the time series (and
c              so the number of columns of x).
c          k = an integer containing the number of time series (and so
c              the number of rows of x).
c          np = an integer containing the order of the autoregressive
c               process.
c
c   Output: u = a double precision real scalar containing the value
c               of the test statistic.
c           ndf1 = an integer containing the numerator degrees of
c                  freedom.
c           ndf2 = an integer containing the denominator degrees of 
c                  freedom.
c           pvaluee = a double precision real scalar containing the
c                     p-value of the test statistic based on the exact
c                     distribution (a product of independent beta
c                     random variables.
c           pvaluec = a double precision real scalar containing the 
c                     p-value of the test statistic based on the chi-
c                     square approximation to the distribution.
c           pvaluef = a double precision real scalar containing the 
c                     p-value of the test statistic based on an F 
c                     distribution.  If p = 1 or 2 or if the number of
c                     non-linear terms in the non-linear model = 1 or
c                     2, the distribution is an exact F distribution.
c
c   Accuracy:  Implicit double precision (a-h,p-z)
c
c   Created: 7/19/97 Bonnie K. Ray
c   Modified: 7/24/97  Jane L. Harvill
c
c   Subprograms called: vech, udists, IMSL subroutines DRGIVN, IMSL
c                       double precision function DMACH
c
c***********************************************************************
c
	parameter(nkmx = 5, nmx = 2000, npmx = 10, nqmx = (npmx*nkmx)**2)
	parameter (nsmx = nqmx + npmx*nkmx)
	implicit double precision (a-h, p-z)
c
	double precision x(nmx,nkmx),xr(nmx,nkmx+nsmx)
	double precision xr2(nmx,nkmx+nsmx),xmin(nsmx),xmin2(nsmx)
	double precision xmax(nsmx),xmax2(nsmx),xt1(npmx*nkmx)
	double precision xt1t(1,npmx*nkmx)   				
	double precision y(nqmx),yfit(nmx,nsmx),ssr(nkmx,nkmx)
	double precision b(nsmx,nsmx),b2(nsmx,nsmx),ssy(nkmx,nkmx)
	double precision r(nsmx,nsmx),r2(nsmx,nsmx)
	double precision d(nsmx),d2(nsmx),tstats(8),tempu(1)
	double precision sse(nkmx,nkmx),sse2(nsmx,nsmx)
	double precision tempx(nmx,nsmx),tempy(nmx,nkmx)
c
	integer inddep1(nkmx),inddep2(nsmx)
	integer indind(npmx*nkmx),indind2(nsmx)
c
	external vech, DRGIVN, DMACH, DGEMM, DLFTSF, DLFDSF
c
c   Initialize variables:
c
	ndf1 = 0
	ndf2 = 0
	u = 0.0d0
	pvaluee = 0.0d0
	pvaluec = 0.0d0
	pvaluef = 0.0d0
c
c
c   Set up the X matrix for the regressions in steps one and two of the
c   test.
c
c   xr contains "data matrix"; xr is [X_t|X_{t-1},...,X_{t-p}] is
c   used for the first regression and is [X_t|X_{t-1},...,X{t-p}|
c   X^2_{t-1},X_{t-1}X_{t-2},...,X_{n-p-1}X_{p-j}] (that is, the
c   first regression xr with all second-order and cross-product
c   terms following.
c
c   tempx contains the matrix of "independent" variables; that is,
c   tempx = [X_{t-1}, ... ,X_{t-p}].
c
c   xt1 = np+i-jth row of [X_{t-1},...,X_{t-p}]
c
c   xt1t = the transpose of xt1.
c
c	iz = the length of the half-stacking vector needed in step two
c
	iz = (np*k)*(np*k+1)/2
c
	do i = 1,n-np
		do j = 0,np
			do l = 1,k
				xr(i,k*j+l) = x(i+np-j,l)
		  	enddo
c
c   Form a vector of additional responses for step two regression:
c   xt1 is the p+i-j row of x for the first regression (of length
c   np*k).
c
			if(j.gt.0) then
				do l = 1,k
					tempx(i,k*(j-1)+l) = x(i+np-j,l)
					xt1(k*(j-1)+l) = x(i+np-j,l)
					xt1t(1,k*(j-1)+l) = xt1(k*(j-1)+l)
				enddo
			endif
		enddo
c
c   The subroutine vech multiplies the two matrices xt1*xt1t and
c   stacks all elements of that product on or below the main 
c   diagonal.  The result is returned in the vector y.
c
c   In this way the second-order and crossproduct terms for the
c   last columns of xr are created.  The following loop appends
c   those terms to xr.
c
		call vech(xt1,xt1t,npmx*nkmx,np*k,1,1,np*k,0,y)
c
		do l = 1,iz
			xr(i,k*np+k+l) = y(l)
		enddo
	enddo
c
c   Begin calculations for step one of multivariate extension of
c   Tsay's (1986) Original F test.
c
c   Perform k-variate AR(np) regression of x on xr.  IMSL subroutine
c   DRGIVN is used to perform calculations.
c
c   DRGIVN is a double precision IMSL subroutine used to fit a 
c   multivariate linear regression model via fast Givens transformation.
c
c   indind is a vector of indices required by DRGIVN.  indind contains
c   the column numbers of xr that are the independent variables.  
c   indind must be of length np*k.
c
c   inddep1 is a vector of indices required by DRGIVN.  inddep1 is of
c   length k containing the column numbers of xr that are the
c   dependent variables.
c
	do i = 1,np*k
		indind(i) = k+i
	enddo
	do i = 1,k
		inddep1(i) = i
	enddo
c
c   DRGIVN will return the following:
c    b = np*k x k matrix containing least squares solution.
c    r = np*k x np*k upper triangular matrix containing the "R" matrix
c        from a QR decomposition of the matrix of regressors.  Since the
c        first argument passed to DRGIVN has a value of 0, the matrix
c        of raw sums of squares and crossproducts for the regressors
c        can be found as r*t*diag(d)*r where diag(d) is the diagonal
c        matrix whose diagonal elements are the elements of the vector
c        d.
c     d = vector of length np*k containing scale factors for fast 
c         Givens transformations.  Since the first argument passed to 
c         DRGIVN has a value of 0, each element of d is 1.0d0.
c     irank = the rank of r.
c     dfe = degrees of freedom for error.
c     sse = k x k matrix containing residual sums of squares and
c           crossproducts.  sse(m,n) contains the current sums of
c           crossproducts of residuals for the mth and nth dependent
c           variables.
c     nrmiss = number of rows of data encountered that contained any
c              missing values.
c     xmin = a vector of length np*k containing the minimum values
c            for each of the regressors.
c     xmax = a vector of length np*k containing the maximum values 
c            for each of the regressors.
c
c    
c    
	call DRGIVN(0,n-np,k*(np+1)+iz,xr,nmx,0,np*k,indind,k,inddep1,
     +	0,0,0,100*DMACH(4),b,nsmx,r,nsmx,d,irank,dfe,sse,
     +	nkmx,nrmiss,xmin,xmax)
c
c  Compute residuals from linear k-variate AR regression and store 
c  in the vector xr2.
c
c  The IMSL subroutine DGEMM is used to performs these calculations.
c  DGEMM assigns the matrix yfit <- 1.0d0*tempx*b + 0.0d0*yfit.  The
c  first arguments passed to DGEMM indicate to not take the transpose
c  of tempx and b, respectively. The remaining arguments are defined
c  as follows:
c     n - np = number of columns of tempx
c     np*k = number of rows of tempx and number of columns of b.  
c     k = number of rows of b.
c     nmx = leading dimension of tempx.
c     npmx*nkmx = leading dimension of b.
c     nmx = leading dimension of yfit.
c
	call DGEMM('N','N',n-np,k,np*k,1.0d0,tempx,nmx,b,nsmx,0.0d0,
     +	yfit,nmx)
c
c   Compute the residuals for the first regression and sort them in
c   the matrix xr2 and tempy.  xr2 will eventually contain residuals
c   from regression 1 (in columns 1 though k) and regression 2 (in
c   columns k+1 through k+iz).
c
	do i = 1,n-np
	do j = 1,k
		xr2(i,j) = xr(i,j) - yfit(i,j)
		tempy(i,j) = xr2(i,j)
	enddo
	enddo

c	write(8,*) 'In MVTsay'
c	write(8,*) 'beta'
c	do i=1,k*np
c	   write(8,*) (b(i,j),j=1,k)
c      enddo
c	write(8,*) 'tempx'
c	do i=1,3
c	write(8,*) (tempx(i,j),j=1,k*np)
c	enddo
c	write(8,*) 'x'
c	do i=1,3
c	write(8,*) (xr(i,j),j=1,k )
c	enddo
c	write(8,*) 'yfit'
c	do i=1,3
c	write(8,*) (yfit(i,j),j=1,k)
c 	enddo
c	write(8,*) 'Res'
c	do i=1,3
c	write(8,*) (xr2(i,j),j=1,k+iz )
c	enddo
c
c   Perform regression two of second order terms on X_t.  Use only
c   third part of xr (second-order and crossproduct) for "dependent"
c   variables.
c
c   DRGIVN is used for this too.
c
	do i = 1,iz
		inddep2(i) = (np+1)*k + i
	enddo
c
	call DRGIVN(0,n-np,k+np*k+iz,xr,nmx,0,np*k,indind,iz,inddep2,
     +	0,0,0,100*DMACH(4),b,nsmx,r,nsmx,d,irank,dfe,sse2,
     +	nsmx,nrmiss,xmin,xmax)

c	 write(8,*) 'XR2'
c	 do i=1,3
c	  write(8,*) (xr2(i,j),j=1,k+iz)
c	 enddo
c
c   Compute residuals for the second regression and store them in the
c   matrix xr2:
c
c   DGEMM is used for this too.
c
	call DGEMM('N','N',n-np,iz,np*k,1.0d0,tempx,nmx,b,nsmx,
     +	0.0d0,yfit,nmx)
c
c	 write(8,*) 'XR2'
c	 do i=1,3
c	  write(8,*) (xr2(i,j),j=1,k+iz)
c	 enddo

	do i = 1,n-np
	do j = 1,iz
		xr2(i,k+j) = xr(i,k+np*k+j) - yfit(i,j)
c	       res2(i,j)=xr2(i,k+j)
	enddo
	enddo
c	write(8,*) 'beta'
c	do i=1,k*np
c	   write(8,*) (b(i,j),j=1,iz)
c      enddo
c	write(8,*) 'yfit'
c	do i=1,3
c	write(8,*) (yfit(i,j),j=1,iz)
c 	enddo
c	write(8,*) 'Res'
c	do i=1,3
c	write(8,*) (xr2(i,k+j),j=1,iz)
c	enddo
c
c   This is the end of the calculations for steps one and two of the
c   testing procedure.
c
c   Begin step three:  regression of residuals from first regression
c   (contained in the first k columns of xr2) on the residuals of
c   the second regression (contained in the k+1 through k+iz columns
c   of xr2).  The residuals from this final regression are calculated.
c
c   DRGIVN is invoked again.  In this call to DRGIVN, sse is the
c   k x k matrix containing the (regression 3) residual sums of squares
c   and cross-products.  The determinant of SSE = sse is used in the
c   denominator of the test statistic.
c
	do i = 1,iz
		indind2(i) = k+i
      enddo
c	 write(8,*) 'XR2'
c	 do i=1,3
c	  write(8,*) (xr2(i,j),j=1,k+iz)
c	 enddo
c
	call DRGIVN(0,n-np,iz+k,xr2,nmx,0,iz,indind2,k,inddep1,0,0,0,
     +	100*dmach(4),b2,nsmx,r2,nsmx,d2,irank,dfe,sse,nkmx,nrmiss,
     +	xmin2,xmax2)
c	 write(8,*) 'XR2'
c	 do i=1,3
c	  write(8,*) (xr2(i,j),j=1,k+iz)
c	 enddo

c     do j=1,k
c	 do i=1,n-np
c	   res1(i)=xr2(i,j)
c       enddo
c	 call DRLSE(n-np,res1,iz,res2,nmx,0,bx,sstx,ssex)
c	 write(8,*) 'sse: ',ssex
c	do i=1,iz
c	write(8,*) bx(i)
c	enddo
c	enddo
c
c      write(8,*) 'last regression'
c	do i=1,iz
c	  write(8,*) (b2(i,j),j=1,k)
c      enddo
c   This call to DMXTF multiplies the residuals from the first
c   regression by themselves to get total sum of squares for the
c   third regression.
c   
	call DMXTXF(n-np,k,tempy,nmx,k,ssy,nkmx)
c	write(8,*) 'SSE'
c	do i=1,k
c	  write(8,*) (sse(i,j),j=1,k)
c      enddo
c
c   Calculate matrix of sum of squared and crossproduct terms for 
c   regression using relationship SSY = SSReg + SSE.  The determinant
c   of ssr is used in the denominator of the test statistic.
c
	do i = 1,k
	do j = 1,k
		ssr(i,j) = ssy(i,j) - sse(i,j)
	enddo
	enddo
c
c
	ndf2 = (n -np)-((np*k)*(np*k+3))/2
	ndf1=iz
c	 Look at these to compare to results for SMTsay when debugging
c	f1 = (ssr(1,1)/dble(ndf1))/(sse(1,1)/dble(ndf2 ))
c	f2 = (ssr(2,2)/dble(ndf1))/(sse(2,2)/dble(ndf2))
      CALL DRHPTE(dble(ndf2),k,sse,nkmx,0,tempu,1,dble(ndf1),ssr, 
     +       nkmx,tstats)
      u1=tstats(1)
	u2=tstats(3)
	u3=tstats(4)
      pvaluee=tstats(5)
	pvaluec=tstats(7)
	pvaluef=tstats(8)

	return
	end
	subroutine mvkeenan(x,n,k,np,u1,u2,u3,ndf1,ndf2,pvaluee,
     +	pvaluec,pvaluef)
c
c***********************************************************************
c					    
c   FORTRAN subroutine to calculate the value of the test statistic
c   for the multivariate extension of Keenan's (1985) test for linearity
c   of a time series.
c
c   Input: x = a matrix of dimension n x k containing the multivariate
c              time series.
c          n = an integer containing the length of the time series (and
c              so the number of columns of x).
c          k = an integer containing the number of time series (and so
c              the number of rows of x).
c          np = an integer containing the order of the autoregressive
c               process.
c
c   Output: u = a double precision real scalar containing the value
c               of the test statistic.
c           ndf1 = an integer containing the numerator degrees of
c                  freedom.
c           ndf2 = an integer containing the denominator degrees of 
c                  freedom.
c           pvaluee = a double precision real scalar containing the
c                     p-value of the test statistic based on the exact
c                     distribution (a product of independent beta
c                     random variables.
c           pvaluec = a double precision real scalar containing the 
c                     p-value of the test statistic based on the chi-
c                     square approximation to the distribution.
c           pvaluef = a double precision real scalar containing the 
c                     p-value of the test statistic based on an F 
c                     distribution.  If p = 1 or 2 or if the number of
c                     non-linear terms in the non-linear model = 1 or
c                     2, the distribution is an exact F distribution.
c
c   Accuracy:  Implicit double precision (a-h,p-z)
c
c   Created: 8/05/97 Bonnie K. Ray
c   Subprograms called: udists, IMSL subroutines DRGIVN, 
c                       double precision function DMACH
c
c***********************************************************************
c
	parameter(nkmx = 5, nmx = 2000, npmx = 10, nqmx = (npmx*nkmx)**2)
c												
	implicit double precision (a-h, p-z)
c
	double precision x(nmx,nkmx),xr(nmx,nkmx+npmx*nkmx)
	double precision xr2(nmx,nkmx+npmx*nkmx),xmin(npmx*nkmx)
	double precision xmax(npmx*nkmx)
	double precision yfit(nmx,nkmx),ssr(nkmx,nkmx)
	double precision b(npmx*nkmx,nkmx),ssy(nkmx,nkmx)
	double precision r(npmx*nkmx,npmx*nkmx)
	double precision d(npmx*nkmx),tempu(1),tstats(8)
	double precision sse(nkmx,nkmx) 
	double precision tempy(nmx,nkmx),tempx(nmx,nkmx*npmx)
	double precision sse2(nkmx,nkmx) 
c
	integer inddep1(nkmx) 
	integer indind(npmx*nkmx),indind2(nkmx)
c
c	external DRGIVN, DMACH, DGEMM, DLFTSF, DLFDSF
c
c   Initialize variables:
c
	ndf1 = 0
	ndf2 = 0
	u = 0.0d0
	pvaluee = 0.0d0
	pvaluec = 0.0d0
	pvaluef = 0.0d0
c
c   Set up the X matrix for the regressions in steps one and two of the
c   test.
c
c   xr contains "data matrix"; xr is [X_t|X_{t-1},...,X_{t-p}] is
c   used for the first regression and  
c
c   tempx contains the matrix of "independent" variables; that is,
c   tempx = [X_{t-1}, ... ,X_{t-p}].
c
c
c
	do i = 1,n-np
		do j = 0,np
			do l = 1,k
			   xr(i,k*j+l) = x(i+np-j,l)
	              if (j .gt. 0) tempx(i,k*(j-1)+l)=x(i+np-j,l)
			enddo
	        enddo
	enddo
c
c   Perform k-variate AR(np) regression of x on xr.  IMSL subroutine
c   DRGIVN is used to perform calculations.
c
c   DRGIVN is a double precision IMSL subroutine used to fit a 
c   multivariate linear regression model via fast Givens transformation.
c
c   indind is a vector of indices required by DRGIVN.  indind contains
c   the column numbers of xr that are the independent variables.  
c   indind must be of length np*k.
c
c   inddep1 is a vector of indices required by DRGIVN.  inddep1 is of
c   length k containing the column numbers of xr that are the
c   dependent variables.
c
	do i = 1,np*k
		indind(i) = k+i
	enddo
	do i = 1,k
		inddep1(i) = i
	enddo
c
c   DRGIVN will return the following:
c    b = np*k x k matrix containing least squares solution.
c    r = np*k x np*k upper triangular matrix containing the "R" matrix
c        from a QR decomposition of the matrix of regressors.  Since the
c        first argument passed to DRGIVN has a value of 0, the matrix
c        of raw sums of squares and crossproducts for the regressors
c        can be found as r*t*diag(d)*r where diag(d) is the diagonal
c        matrix whose diagonal elements are the elements of the vector
c        d.
c     d = vector of length np*k containing scale factors for fast 
c         Givens transformations.  Since the first argument passed to 
c         DRGIVN has a value of 0, each element of d is 1.0d0.
c     irank = the rank of r.
c     dfe = degrees of freedom for error.
c     sse = k x k matrix containing residual sums of squares and
c           crossproducts.  sse(m,n) contains the current sums of
c           crossproducts of residuals for the mth and nth dependent
c           variables.
c     nrmiss = number of rows of data encountered that contained any
c              missing values.
c     xmin = a vector of length np*k containing the minimum values
c            for each of the regressors.
c     xmax = a vector of length np*k containing the maximum values 
c            for each of the regressors.
c
c    
c    
	call DRGIVN(0,n-np,k*(np+1),xr,nmx,0,np*k,indind,k,inddep1,
     +    0,0,0,100*DMACH(4),b,npmx*nkmx,r,npmx*nkmx,d,irank,dfe,sse,
     +    nkmx,nrmiss,xmin,xmax)
c
c  Compute square of fitted values from linear k-variate AR regression and store 
c  in the xr for next regression.
c
c  The IMSL subroutine DGEMM is used to performs these calculations.
c  DGEMM assigns the matrix yfit <- 1.0d0*tempx*b + 0.0d0*yfit.  The
c  first arguments passed to DGEMM indicate to not take the transpose
c  of tempx and b, respectively. The remaining arguments are defined
c  as follows:
c     n - np = number of columns of tempx
c     np*k = number of rows  of rows of b.  
c     k = number of columns of b.
c     nmx = leading dimension of tempx.
c     npmx*nkmx = leading dimension of b.
c     nmx = leading dimension of yfit.
c
	call DGEMM('N','N',n-np,k,np*k,1.0d0,tempx,nmx,b,npmx*nkmx,0.0d0,
     +	yfit,nmx)
	 do i=1,n-np
	   do j=1,k
	      xr2(i,j)=xr(i,j)-yfit(i,j) !Residuals
	      tempy(i,j)=xr2(i,j)	     ! Residuals again
	      xr(i,j)=yfit(i,j)**2.0d0   !Square of fits
	   enddo
      enddo
c
c   Perform regression two of squared fitted values.  
c
	call DRGIVN(0,n-np,k+np*k,xr,nmx,0,np*k,indind,k,inddep1,
     +	0,0,0,100*DMACH(4),b,npmx*nkmx,r,npmx*nkmx,d,irank,dfe,
     +	sse2,nkmx,nrmiss,xmin,xmax)
c
c   Compute residuals for the second regression and store them in the
c   matrix xr2:
c
c   DGEMM is used for this too.
c
	call DGEMM('N','N',n-np,k,np*k,1.0d0,tempx,nmx,b,npmx*nkmx,
     +	0.0d0,yfit,nmx)
c
	do i = 1,n-np
	do j = 1,k
		xr2(i,k+j) = xr(i,j) -yfit(i,j)
	enddo
	enddo
c
c   Begin step three:  regression of residuals from first regression
c   (contained in the first k columns of xr2) on the residuals of
c   the second regression (contained in the k+1 through k+k columns
c   of xr2).  
c
c   DRGIVN is invoked again.  In this call to DRGIVN, sse is the
c   k x k matrix containing the (regression 3) residual sums of squares
c   and cross-products.  The determinant of SSE = sse is used in the
c   denominator of the test statistic.
c
	do i = 1,k
		indind2(i) = k+i
	enddo
c
	call DRGIVN(0,n-np,k+k,xr2,nmx,0,k,indind2,k,inddep1,0,0,0,
     +	100*dmach(4),b,nkmx*npmx,r,nkmx*npmx,d,irank,dfe,sse,nkmx,
     +	nrmiss,xmin,xmax)
c
c   This call to DMXTF multiplies the residuals from the first
c   regression by themselves to get total sum of squares for the
c   third regression.
c   
	call DMXTXF(n-np,k,tempy,nmx,k,ssy,nkmx)
c
c   Calculate matrix of sum of squared and crossproduct terms for 
c   regression using relationship SSY = SSReg + SSE.  
c
	do i = 1,k
	do j = 1,k
		ssr(i,j) = ssy(i,j) - sse(i,j)
	enddo
	enddo
c
	ndf2=(n-np-np*k)-k
	ndf1=k
      CALL DRHPTE(dble(ndf2),k,sse,nkmx,0,tempu,1,dble(ndf1),ssr, 
     +       nkmx,tstats)

      u1=tstats(1)
	u2=tstats(3)
	u3=tstats(4)
      pvaluee=tstats(5)
	pvaluec=tstats(7)
	pvaluef=tstats(8)

	
	return
	end
	
	subroutine mvlrt(x,n,k,np,u1,u2,u3,ndf1,ndf2,pvaluee,pvaluec,
     +	pvaluef,iflag)
c
c**********************************************************************
c
c   FORTRAN subroutine to calculate the likelihood ratio statistic
c   for a test of the linearity of a time series.
c
c   Input: x = a double precision matrix of dimension n x k containing
c              the time series.
c          n = an integer containing the length of the time series
c              and the number of columns of x.
c          k = an integer containing the number of time series and
c              the number of rows of x.
c          np = an integer containing the order of the k-variate
c               autoregressive process.
c
c
c   Output: u = a double precision real scalar containing the
c               value of the likelihood ratio test statistic.
c           ndf1 = an integer containing the numerator degrees of
c                  freedom.
c           ndf2 = an integer containing the denominator degrees of
c                  freedom.
c           pvaluee = a double precision real scalar containing the 
c                     p-value of the test statistic from its exact 
c                     distribution.
c           pvaluec = a double precision real scalar containing the
c                     p-value of the test statistic from the chi-square
c                     appproximation to the exact distribution.
c           pvaluef = a double precision real scalar conatining the
c                     p-value of the test statistic from the F 
c                     approximation to the exact distribution.
c
c   Accuracy:  Implicit double precision (a-h,p-z)
c
c   Created: 7/19/97 Bonnie K. Ray
c   Modified: 7/27/97 Jane L. Harvill
c
c   Subprograms called: vech, IMSL subroutine DRGIVN,  IMSL subroutine
c                       DLFTSF, IMSL subroutine DLFDSF, IMSL double
c                       precision function DMACH, udists.
c
c**********************************************************************
c
	parameter (nkmx =5, nmx = 2000, npmx = 10, nqmx = (npmx*nkmx)**2)
	parameter (nsmx = nqmx + npmx*nkmx)
c
	implicit double precision (a - h, p - z)
c
	double precision x(nmx,nkmx),xr(nmx,nkmx+nsmx),b(nsmx,nsmx)
	double precision sse1(nkmx,nkmx),sse2(nkmx,nkmx),ssr(nkmx,nkmx)
	double precision xt1(nkmx*npmx),xt1t(1,nkmx*npmx),y(nqmx),tempu(1)
	double precision r(nsmx,nsmx),d(nsmx),xmin(nsmx),xmax(nsmx) 
	double precision tstats(8)
c
	integer inddep(nkmx),indind(npmx*nkmx), indind2(nsmx)
c
	external vech, DRGIVN, DLFTSF, DLFDSF, DMACH
c
c   Initialize matrices and constants:
c
	ndf1 = 0
	ndf2 = 0
	u = 0.0d0
	pvaluee = 0.0d0
	pvaluec = 0.0d0
	pvaluef = 0.0d0
c
c
c  Set up data matrix for the first and second regressions in a form
c  to be used in the IMSL subroutine DRGIVN.  The "data matrix" is
c  xr = [X_t|X_{t-1},...,X_{t-p}|X^2{t-1},X_{t-1}X{t-2},...,X^2_{t-p}].
c
	iz = (np*k)*(np*k+1)/2
c
	do i = 1,n-np
		do j = 0,np
			do l = 1,k
				xr(i,k*j+l) = x(i+np-j,l)
			enddo
c
c  Form vector of additional responses for second regression (full
c  model). xt1 = p+i-j row of original data matrix (x). xt1t is the
c  transpose of xt.
c
			if(j.gt.0) then
				do l = 1,k
					xt1(k*(j-1)+l) = x(i+np-j,l)
					xt1t(1,k*(j-1)+l) = xt1(k*(j-1)+l)
				enddo
			endif
		enddo
		call vech(xt1,xt1t,npmx*nkmx,np*k,1,1,np*k,0,y)
c
		do l = 1,iz
			xr(i,k*np+k+l) = y(l)
		enddo
	enddo
c
c   Perform first regression using the "reduced model" containing
c   only linear terms and no nonlinear terms.
c
c   IMSL subroutine DRGIVN is used to perform calculations.
c
c   DRGIVN is a double precision IMSL subroutine used to fit a 
c   multivariate linear regression model via fast Givens transformation.
c
c   indind is a vector of indices required by DRGIVN.  indind contains
c   the column numbers of xr that are the independent variables.  
c   indind must be of length np*k.
c
c   inddep is a vector of indices required by DRGIVN.  inddep is of
c   length k containing the column numbers of xr that are the
c   dependent variables.
c
	do i = 1,np*k
		indind(i) = k + i
	enddo
	do i = 1,k
		inddep(i) = i
	enddo
c
	call DRGIVN(0,n-np,k+np*k+iz,xr,nmx,0,np*k,indind,k,inddep,0,0,
     +	0,100*dmach(4),b,nsmx,r,nsmx,d,irank,dfe,sse1,nkmx,nrmiss,
     +	xmin,xmax)

	if (iflag .eq. 1)  then
	  write(10,*) 'Estimated Coefficients from Linear Model'
	  do i=1,k*np
	    write(10,100) (b(i,j),j=1,k)
	  enddo
	  write(10,*) 'SSE from Linear Model'
	  do i=1,k
	    write(10,100) (sse1(i,j),j=1,k)
	  enddo
100	format(4F15.4)
      endif
c
c  Perform regression on "full model" (includes linear and all second-
c  order terms.  
c
c  Again call DRGIVN.
c
	do i = 1,np*k+iz
		indind2(i) = k + i
	enddo
c
	call DRGIVN(0,n-np,k+np*k+iz,xr,nmx,0,np*k+iz,indind2,k,inddep,
     +	0,0,0,100*dmach(4),b,nsmx,r,nsmx,d,irank,dfe,sse2,nkmx,
     +	nrmiss,xmin,xmax)

	if (iflag .eq. 1)then
	  write(10,*) 'Estimated Coefficients from Full Model'
	  do i=1,k*np+iz
	    write(10,100) (b(i,j),j=1,k)
	  enddo
	  write(10,*) 'SSE from Full Model'
	  do i=1,k
	    write(10,100) (sse2(i,j),j=1,k)
	  enddo
	  write(10,*) 'Dependent Variables'
	  do i=1,n-np
	   write(10,110) (xr(i,j), j=1,k)
	  enddo
	  write(10,*) 'Regressors for Linear Model'
	  do i=1,n-np
	   write(10,110) (xr(i,j), j=k+1,k+k*np)
	  enddo
	  write(10,*) 'Extra Regressors for Full Model'
	  do i=1,n-np
	   write(10,110) (xr(i,j), j=k+k*np+1,k+k*np+iz)
	  enddo
110	format(50F15.4) 
      endif
c
	ssr=sse1-sse2
	ndf1=iz
	ndf2=(n-np)-np*k-iz
c	ndf2=n-np*k-iz
      CALL DRHPTE(dble(ndf2),k,sse2,nkmx,0,tempu,1,dble(ndf1),
     +	ssr,nkmx,tstats)
      u1=tstats(1)
      u2=tstats(3)
	u3=tstats(4)
	pvaluee=tstats(5)
	pvaluec=tstats(7)
	pvaluef=tstats(8) 

	return
	end
	
		subroutine origf(x,n,np,f,ndf1,ndf2,pvalue)
c
c**********************************************************************
c
c   FORTRAN subroutine to calculate Tsay's (1986) Original F test
c   statistic and its pvalue.
c
c   Input: x = a double precision vector of length n containing the
c              time series.
c          n = an integer containing the length of the time series.
c          np = an integer containing the order of the autoregressive
c               process.
c
c   Output: f = a double precision real scalar containing the value
c               of the test statistic.
c           ndf1 = an integer containing the numerator degrees of 
c                  freedom of the test statistic.
c           ndf2 = an integer containing the denominator degrees of
c                  freedom of the test statistic.
c           pvalue = a double precision real scalar containing the
c                    p-value of the test statistic from an F(ndf1,ndf2)
c                    distribution.
c
c   Accuracy: implicit double precision (a-h,p-z)
c
c   Written: 7/27/97 Jane L. Harvill
c
c   Subprograms called: IMSL subroutine DRLSE, IMSL subroutine DGEMV,
c                       vech, IMSL subroutine DRGIVN, IMSL subroutine
c                       DGEMM, IMSL double precision function DFDF,
c                       IMSL double precision function DMACH.
c
c**********************************************************************
c
	parameter(nmx = 2000, nkmx = 5,npmx = 10, nqmx = npmx*(npmx+1)/2)
c
	implicit double precision (a - h, p - z)
c
	double precision x(nmx),y(nmx),xr(nmx,npmx)
	double precision xt(nkmx*npmx),xtt(1,npmx*nkmx)
	double precision beta(npmx),yfit(nmx),res1(nmx)
c
	double precision z(nmx,nqmx+npmx),zv((npmx*nkmx)**2)
	double precision b(nqmx,nqmx),r(npmx,npmx),d(npmx),sse2(nqmx,nqmx)
	double precision xmin(npmx),xmax(npmx),yfit2(nmx,nqmx)
	double precision res2(nmx,nqmx),beta2(nqmx)
c
	integer indind(npmx),inddep(nqmx)
c
c	external DRLSE, DGEMV, vech, DRGIVN, DGEMM, DFDF, DMACH
c
c   Initialize constants and matrices.
c     First major loop - y,yfit,res1,xr,z,res2
c     Second major loop - xt,xtt,beta,r,d,indind
c     Third major loop - zv,b,sse2,beta2,inddep
c
	ndf1 = 0
	ndf2 = 0
	pvalue = 0.0d0
	f = 0.0d0
	sse1 = 0.0d0
	sst = 0.0d0
c
c
c   Build matrix of "dependent" variables for first and second
c   regression.  The matrices to be built are described below.
c   xr = [X_{t-1},...,X_{t-p}] for t = p+1,...,N.
c   y is a vector containing the "effective observations"; that is
c   y = (X_{p+1},...,X_{n}).
c   xt is the ith row of xr and xtt is the transpose of xt.  These
c   are used in obtaining the half-stack vector z for each 
c   observation.
c
	ndf1 = np*(np+1)/2
	do i = 1,n-np
		y(i) = x(np+i)
		do j = 1,np
			xr(i,j) = x(np+i-j)
			z(i,j) = xr(i,j)
			xt(j) = xr(i,j)
			xtt(1,j) = xt(j)
		enddo
		call vech(xt,xtt,npmx,np,1,1,np,0,zv)
		do j = 1,ndf1
			z(i,j+np) = zv(j)
		enddo
	enddo
c
c   Calculate least squares regression estimates of the coefficients
c   of the autoregressive process of order np.
c
	call DRLSE(n-np,y,np,xr,nmx,0,beta,sst,sse1)
c
c   Calculate residuals from above regression.  These residuals will
c   be used as "dependent" variables in the third step of the test.
c
c   IMSL subroutine DGEMV multiplies a matrix times a vector and
c   assigns to yfit <- 1.0d0*y*beta + 0.0d0*yfit.
c
	call DGEMV('N',n-np,np,1.0d0,xr,nmx,beta,1,0.0d0,yfit,1)
c
c
c   Calculate residuals:
c
	do i = 1,n-np
		res1(i) = y(i) - yfit(i)
	enddo
c
c   Now run second regression by regressing the half-stacking vector
c   z on the data matrix xr.  Obtain residuals.  IMSL subroutines
c   DRGIVN and DGEMM are used in a similar manner for these
c   computations.
c
c   DRGIVN is a double precision IMSL subroutine used to fit a 
c   multivariate linear regression model via fast Givens transformation.
c
c   indind is a vector of indices required by DRGIVN.  indind contains
c   the column numbers of z that are the independent variables.  
c   indind is of length np.
c
c   inddep is a vector of indices required by DRGIVN.  inddep is of
c   length ndf1 containing the column numbers of z that are the
c   dependent variables.
c
	do i = 1,np
		indind(i) = i
	enddo
	do i = 1,ndf1
		inddep(i) = np + i
	enddo
c
	call DRGIVN(0,n-np,np+ndf1,z,nmx,0,np,indind,ndf1,inddep,0,0,0,
     +	100*dmach(4),b,nqmx,r,npmx,d,irank,dfe,sse2,nqmx,nrmiss,
     +	xmin,xmax)
c
c   DRGIVN will return the following:
c    b = np x ndf1 matrix containing least squares solution.
c    r = np x np upper triangular matrix containing the "R" matrix
c        from a QR decomposition of the matrix of regressors.  Since the
c        first argument passed to DRGIVN has a value of 0, the matrix
c        of raw sums of squares and crossproducts for the regressors
c        can be found as r*t*diag(d)*r where diag(d) is the diagonal
c        matrix whose diagonal elements are the elements of the vector
c        d.
c     d = vector of length np containing scale factors for fast 
c         Givens transformations.  Since the first argument passed to 
c         DRGIVN has a value of 0, each element of d is 1.0d0.
c     irank = the rank of r.
c     dfe = degrees of freedom for error.
c     sse = ndf1 x ndf1 matrix containing residual sums of squares and
c           crossproducts.  sse(m,n) contains the current sums of
c           crossproducts of residuals for the mth and nth dependent
c           variables.
c     nrmiss = number of rows of data encountered that contained any
c              missing values.
c     xmin = a vector of length np containing the minimum values
c            for each of the regressors.
c     xmax = a vector of length np containing the maximum values 
c            for each of the regressors.     
c
c  The IMSL subroutine DGEMM is used to performs these calculations.
c  DGEMM assigns the matrix yfit2 <- 1.0d0*xr*b + 0.0d0*yfit2.  The
c  first arguments passed to DGEMM indicate to not take the transpose
c  of xr and b, respectively. The remaining arguments are defined
c  as follows:
c     n - np = number of columns of xr
c     np = number of rows of xr and number of columns of b.  
c     ndf1 = number of rows of b.
c     nmx = leading dimension of xr.
c     npmx = leading dimension of b.
c     nmx = leading dimension of yfit2.
c
	call DGEMM('N','N',n-np,ndf1,np,1.0d0,xr,nmx,b,nqmx,0.0d0,yfit2,
     +	nmx)
c
c   Calculate residual matrix:
c
	do i = 1,n-np
	do j = 1,ndf1
		res2(i,j) = z(i,np+j) - yfit2(i,j)
	enddo
	enddo
c
c   Perform third and final regression.  Regress residuals from the
c   first regression on the residuals from the second regression.	
c
c   Use DRLSE to perform calculations.
c
	call DRLSE(n-np,res1,ndf1,res2,nmx,0,beta2,sst,sse)
c
	ndf2 = n - np*(np+3)/2
c
	ssr = sst - sse
c
	f = (ssr/dble(ndf1))/(sse/dble(ndf2))
c
	pvalue = 1 - DFDF(f,dble(ndf1),dble(ndf2))
c
	return
      end	
	
	subroutine semimultf(x,k,is,n,np,f,ndf1,ndf2,pvalue)
c
c**********************************************************************
c
c   FORTRAN subroutine to calculate a semimultivariate version of Tsay's (1986) 
c    Original F test statistic and its pvalue.
c
c   Input: x = a double precision matrix of length n containing k-variate 
c              time series.
c	     k=number of time series
c	     is=  the index of the time series to test
c          n = an integer containing the length of the time series.
c          np = an integer containing the order of the autoregressive
c               process.
c
c   Output: f = a double precision real scalar containing the value
c               of the test statistic.
c           ndf1 = an integer containing the numerator degrees of 
c                  freedom of the test statistic.
c           ndf2 = an integer containing the denominator degrees of
c                  freedom of the test statistic.
c           pvalue = a double precision real scalar containing the
c                    p-value of the test statistic from an F(ndf1,ndf2)
c                    distribution.
c
c   Accuracy: implicit double precision (a-h,p-z)
c
c   Written: 10/2/97 Bonnie Ray
c
c   Subprograms called: IMSL subroutine DRLSE, IMSL subroutine DGEMV,
c                       vech, IMSL subroutine DRGIVN, IMSL subroutine
c                       DGEMM, IMSL double precision function DFDF.
c
c**********************************************************************
c
	parameter(nmx = 2000, npmx = 10, nkmx = 5)
	parameter(nqmx = (npmx*nkmx)*(nkmx*npmx+1)/2)
c
	implicit double precision (a - h, p - z)
c
	double precision x(nmx,nkmx),y(nmx),xr(nmx,npmx*nkmx)
	double precision beta(npmx*nkmx),yfit(nmx),res1(nmx)
 	double precision z(nmx,nqmx+npmx*nkmx),zv((nkmx*npmx)**2)
	double precision xtt(1,npmx*nkmx)
 	double precision b(nqmx,nqmx),r(npmx*nkmx,npmx*nkmx),d(npmx*nkmx)
	double precision sse2(nqmx,nqmx),xt(npmx*nkmx)
	double precision xmin(npmx*nkmx),xmax(npmx*nkmx),yfit2(nmx,nqmx)
	double precision res2(nmx,nqmx),beta2(nqmx)
c
	integer indind(npmx*nkmx),inddep(nqmx)
c
c	external DRLSE, DGEMV, vech, DRGIVN, DGEMM, DFDF
c
c   Initialize constants and matrices.
c     First major loop - y,yfit,res1,xr,z,res2
c     Second major loop - xt,xtt,beta,b,r,d,indind
c     Third major loop - zv,sse2,beta2,inddep
c
	ndf1 = 0
	ndf2 = 0
	pvalue = 0.0d0
	f = 0.0d0
	sse1 = 0.0d0
	sst = 0.0d0
c
c   Build matrix of "dependent" variables for first and second
c   regression.  The matrices to be built are described below.
c   xr = [X_{t-1},...,X_{t-p}] for t = p+1,...,N.
c   y is a vector containing the "effective observations"; that is
c   y = (X_{p+1},...,X_{n}).
c   xt is the ith row of xr and xtt is the transpose of xt.  These
c   are used in obtaining the half-stack vector z for each 
c   observation.
c
	iz = (k*np)*(k*np+1)/2
	do i = 1,n-np
		y(i) = x(np+i,is)
	       ic=0
             do l=1,k
 	         do j = 1,np
	              ic=ic+1
		          xr(i,ic) = x(np+i-j,l)
			      z(i,ic) = xr(i,ic)
			      xt(ic) = xr(i,ic)
			      xtt(1,ic) = xt(ic)
		      enddo
	       enddo
		call vech(xt,xtt,npmx*nkmx,np*k,1,1,np*k,0,zv)
		do j = 1,iz
			z(i,j+np*k) = zv(j)
		enddo
	enddo
c
c   Calculate least squares regression estimates of the coefficients
c   of the autoregressive process of order np.
c
	call DRLSE(n-np,y,np*k,xr,nmx,0,beta,sst,sse1)
c
c   Calculate residuals from above regression.  These residuals will
c   be used as "dependent" variables in the third step of the test.
c
c   IMSL subroutine DGEMV multiplies a matrix times a vector and
c   assigns to yfit <- 1.0d0*y*beta + 0.0d0*yfit.
c
	call DGEMV('N',n-np,np*k,1.0d0,xr,nmx,beta,1,0.0d0,yfit,1)
c
c
c   Calculate residuals:
c
	do i = 1,n-np
		res1(i) = y(i) - yfit(i)
	enddo
c
c   Now run second regression by regressing the half-stacking vector
c   z on the data matrix xr.  Obtain residuals.  IMSL subroutines
c   DRGIVN and DGEMM are used in a similar manner for these
c   computations.
c
c   DRGIVN is a double precision IMSL subroutine used to fit a 
c   multivariate linear regression model via fast Givens transformation.
c
c   indind is a vector of indices required by DRGIVN.  indind contains
c   the column numbers of z that are the independent variables.  
c   indind is of length np.
c
c   inddep is a vector of indices required by DRGIVN.  inddep is of
c   length iz containing the column numbers of z that are the
c   dependent variables.
c
	do i = 1,np*k
		indind(i) = i
	enddo
	do i = 1,iz
	inddep(i) = np*k + i
	enddo
c
	call DRGIVN(0,n-np,np*k+iz,z,nmx,0,np*k,indind,iz,inddep,0,0,0,
     +	100*dmach(4),b,nqmx,r,npmx*nkmx,d,irank,dfe,sse2,nqmx,
     +       nrmiss,xmin,xmax)
c
c   DRGIVN will return the following:
c    b = np x iz matrix containing least squares solution.
c    r = np x np upper triangular matrix containing the "R" matrix
c        from a QR decomposition of the matrix of regressors.  Since the
c        first argument passed to DRGIVN has a value of 0, the matrix
c        of raw sums of squares and crossproducts for the regressors
c        can be found as r*t*diag(d)*r where diag(d) is the diagonal
c        matrix whose diagonal elements are the elements of the vector
c        d.
c     d = vector of length np containing scale factors for fast 
c         Givens transformations.  Since the first argument passed to 
c         DRGIVN has a value of 0, each element of d is 1.0d0.
c     irank = the rank of r.
c     dfe = degrees of freedom for error.
c     sse = iz x iz matrix containing residual sums of squares and
c           crossproducts.  sse(m,n) contains the current sums of
c           crossproducts of residuals for the mth and nth dependent
c           variables.
c     nrmiss = number of rows of data encountered that contained any
c              missing values.
c     xmin = a vector of length np containing the minimum values
c            for each of the regressors.
c     xmax = a vector of length np containing the maximum values 
c            for each of the regressors.     
c
c  The IMSL subroutine DGEMM is used to performs these calculations.
c  DGEMM assigns the matrix yfit2 <- 1.0d0*xr*b + 0.0d0*yfit2.  The
c  first arguments passed to DGEMM indicate to not take the transpose
c  of xr and b, respectively. The remaining arguments are defined
c  as follows:
c     n - np = number of columns of xr
c     np = number of rows of xr and number of columns of b.  
c     iz = number of rows of b.
c     nmx = leading dimension of xr.
c     npmx = leading dimension of b.
c     nmx = leading dimension of yfit2.
c
	call DGEMM('N','N',n-np,iz,np*k,1.0d0,xr,nmx,b,nqmx,0.0d0,
     + 	yfit2,nmx)
c
c   Calculate residual matrix:
c
	do i = 1,n-np
	do j = 1,iz
		res2(i,j) = z(i,np*k+j) - yfit2(i,j)
	enddo
	enddo
c
c   Perform third and final regression.  Regress residuals from the
c   first regression on the residuals from the second regression.	
c
c   Use DRLSE to perform calculations.
c
	call DRLSE(n-np,res1,iz,res2,nmx,0,beta2,sst,sse)
c
	ndf1 = iz
	ndf2 = n - ((np*k)*(np*k+3))/2 
c
	ssr = sst - sse
c
	f = (ssr/dble(ndf1))/(sse/dble(ndf2))
c
	pvalue = 1 - DFDF(f,dble(ndf1),dble(ndf2))
c
	return
	end
	
	subroutine kptaus(x,n,k,ip,ptol,wk,z,kendtaus,tauprobs,kendptaus,
     +	ptauprobs)
c**********************************************************************
c
c  FORTRAN subroutine for calculating Kendall's partial tau for a
c  vector time series.
c
c  Accuracy: (Implicit) double precision
c
c  Input: x = a double precision matrix of dimension n x k containing
c             the vector time series.
c         maxn = an integer scalar containing the number of rows of
c                x and ranks in the calling routine.
c         n = an integer scalar containing the length of the vector
c             time series contained in x.
c         k = an integer scalar containing the number of components
c             of the vector time series x.
c         ip = the maximum lag for calculating Kendall's (partial) tau.
c              Kendall's (partial) tau will be calculated for lags
c              1,...,ip.
c         ptol = a double precision scalar containing the percentage
c                of the sample size for calculating the tolerance 
c                used in calculating Kendall's partial tau.  The
c                tolerace = ptol*n/100 is based on rank transformed
c                data.
c         maxk = an integer scalar containing the number of rows of
c                kendtaus and tauprobs in the calling routine.
c         maxp = an integer scalar containing the maximum third
c                dimension of kendtaus and tauprobs, as well as the
c                number of rows of z1 and z2 in the calling routine.
c         maxwk = an integer scalar containing the number of rows
c                 of wk in the calling routine.
c         wk   = a double precision matrix of dimension n(n-1)/2 + 10
c                by k+3.
c         z = a double precision matrix of dimension (ip-1) x k used
c             in calculating Kendall's partial tau.
c
c  Output: kendtaus = a double precision three-dimensional array of 
c                     size k x k x p containing the values of Kendall's
c                     tau.
c          tauprobs = a double precision three-dimensional array of
c                     size k x k x p containing the probabilitys of
c                     achieving the Kendall's tau under the null
c                     hypothesis (of no relationship).
c          kendptaus = a double precision three-dimensional array of 
c                      size k x k x p containing the values of Kendall's
c                      partial tau.
c          ptauprobs = a double precision three-dimensional array of
c                      size k x k x p containing the probabilitys of
c                      achieving the Kendall's partial tau under the 
c                      null hypothesis (of no relationship).
c
c  Subprograms called: none.
c
c  IMSL subprograms called: DRANKS, DKENDL, DNR2RR, DNORDF (function) 
c
c**********************************************************************
c
	implicit double precision (a-h,p-z)
c
	parameter (maxn = 2000, maxk = 5, maxlag = 10, maxwk = 71950)
c
	double precision x(maxn,maxk), wk(maxwk,maxk+3), z(maxlag,maxk)
	double precision x1(maxn), x2(maxn)
	double precision kendtaus(maxk,maxk,maxlag)
	double precision tauprobs(maxk,maxk,maxlag)
	double precision kendptaus(maxk,maxk,maxlag)
	double precision ptauprobs(maxk,maxk,maxlag)
	double precision r(maxn), w(maxn)
	data fuzz/1.0d-10/
c
c  Initialize values for calculating standard error of Kendall's
c  partial tau:
c
	sr = 0.0d0
	sw = 0.0d0
	srw = 0.0d0
	sr2 = 0.0d0
	sw2 = 0.0d0
c
c  Calculate the matrix of Kendall's (partial) taus and approximate
c  p-values: 
c
c  For lag 1 Kendall's tau = Kendall's partial tau:
c
c  itsr = component index of "response" time series model.
c  itsp = component index of "predictor" time series model.
c
c
	nobs = n - 1
	do itsr = 1,k
		do itsp = 1,k
	        x1(1:nobs) = x(2:n,itsr)
	        x2(1:nobs) = x(1:nobs,itsp)
			call DKENDL(nobs,x1,x2,fuzz,wk(1,1),wk(10,1))
     			kendtaus(itsr,itsp,1) = wk(1,1)
	        if (kendtaus(itsr,itsp,1).lt.0.0d0) then 
      			tauprobs(itsr,itsp,1) = (1.0d0-wk(7,1))
			else	 
			    tauprobs(itsr,itsp,1) = wk(7,1) 
	        endif								
	        kendptaus(itsr,itsp,1) = wk(1,1)
			ptauprobs(itsr,itsp,1) = tauprobs(itsr,itsp,1)
		enddo
	enddo
c
c  Now calculate matrix of Kendall's (partial) taus for lags > 1
c  and approximate p-values:
c
c
	if(ip.gt.1) then
		do ilag = 2,ip
			nobs = n - ilag
			do itsr = 1,k
			do itsp = 1,k
				x1(1:nobs) = x((ilag+1):n,itsr)
				x2(1:nobs) = x(1:nobs,itsp)
				call DKENDL(nobs,x1,x2,fuzz,wk(1,1),wk(10,1))
     				kendtaus(itsr,itsp,ilag) = wk(1,1)
				if (kendtaus(itsr,itsp,ilag).lt.0.0d0) then 
					pcons = 1.0d0 - wk(7,1)
				else
					pcons = wk(7,1)
				endif
				tauprobs(itsr,itsp,ilag) = pcons 
			enddo
			enddo
		enddo
c
		tol = ptol*dble(n)/100.0d0
		do ilag = 2,ip
			nobs = n - ilag
			nobsz = k*(ilag - 1)
			do itsr = 1,k
c
c  Rank transform the data:
c
c  First ranks of "response" part of time series model:
c				
				call DRANKS(nobs,x(ilag+1,itsr),fuzz,0,0,wk(1,2))
c
c  Now ranks of "predictor" part of time series model:
c
				do itsp = 1,k
					call DRANKS(nobs,x(1,itsp),fuzz,0,0,wk(1,itsp+2))
				enddo
c
c  Determine if |z(i) - z(j)| <= tol, where 
c  z(i) = (x(i+2,1),...,x(i+ilag-1,k)), i = 1,2,...,n-ilag.
c
				do itsp = 1,k
					c   = 0.0d0
					d   = 0.0d0
					sr  = 0.0d0
					sr2 = 0.0d0
					sw  = 0.0d0
					sw2 = 0.0d0
					srw = 0.0d0					
					r(1:nobs) = 0.0d0
					w(1:nobs) = 0.0d0
					do iobs = 1,nobs
						cc = 0.0d0
						dd = 0.0d0
						nrowsz = ilag - 1
						do jj = 1,k
						do ii = 1,nrowsz
							z(ii,jj) = wk(iobs+ii,jj+2)
						enddo
						enddo
						do iobs2 = 1,nobs
							do jj = 1,k
							do ii = 1,nrowsz
								wk(ii,k+3)= z(ii,jj)-wk(iobs2+ii,jj+2)
							enddo
							enddo
							call DNR2RR(nrowsz,k,wk(1,k+3),maxn,zsize)
							if(zsize.le.tol.and.zsize.gt.fuzz) then
								r(iobs) = r(iobs) + 1.0d0
								diff1 = x(iobs,itsr) - x(iobs2,itsr)
					     		diff2 = x(iobs+ilag,itsp)-x(iobs2+ilag
     +								,itsp)
								prod = diff1*diff2
								if(prod.lt.0.0d0) dd = dd + 1.0d0
								if(prod.gt.0.0d0) cc = cc + 1.0d0
							endif
						enddo
						w(iobs) = cc - dd
						c = c + cc
						d = d + dd
					enddo
					do i = 1,nobs
						sr = sr + r(i)
						sr2 = sr2 + r(i)*r(i)
						sw = sw + w(i)
						sw2 = sw2 + w(i)*w(i)
						srw	= srw + r(i)*w(i)
					enddo
					rad = sr*sr*sw2 - 2.0d0*sr*sw*srw + sw*sw*sr2
					if(sr.eq.0.0d0) then
						dkpt = 0.0d0
						sdkpt = 1.0d0
					else
						dkpt = (c-d)/sr
						sdkpt = 2.0d0*dsqrt(rad)/(sr*sr)
					endif					
					zstat = dkpt/sdkpt
					kendptaus(itsr,itsp,ilag) = dkpt
	                if(dkpt.le.0.0d0) then
						ptauprobs(itsr,itsp,ilag) = DNORDF(zstat)
					else
						ptauprobs(itsr,itsp,ilag) = 1 - DNORDF(zstat)
				    endif 
				enddo
			enddo
		enddo
	endif
c
	return
	end
	
	subroutine compr(n,nlag,k,x,in,r,rt)
c	Subroutine to compute R_{i,j} at lags 1,...,nlag
	parameter (maxn=2000, maxk=5, maxp=10,maxlag=10)
  	implicit double precision (a-h,p-z)
	double precision x(maxn,maxk),r(maxlag,maxk,maxk),sigx(maxk)
	double precision sum1(maxk),xt(maxn),yt(maxn)
	double precision rt(maxlag,maxk,maxk)
c	  Compute mean and standard deviation of each series
	sum1=0.0d0
	sigx=0.0d0
	do i=1,k
	   do j=1,n
	     sum1(i)=sum1(i)+x(j,i)
	     sigx(i)=sigx(i)+x(j,i)**2.
	   enddo
	enddo
	do i=1,k
	   sum1(i)=sum1(i)/dble(n)
	   sigx(i)=((sigx(i)-dble(n)*sum1(i)**2.d0)/dble(n-1))**.5d0
	enddo
c
	do i=1,nlag
	  do j=1,k
	    do l=1,k
	      do m=1,n-i
	        xt(m)=(x(m+i,j)-sum1(j))/sigx(j)
	        yt(m)=(x(m,l)-sum1(l))/sigx(l)
	      enddo
	     call hbivar2(in,n-i,xt,yt,deltai,rho)
	     r(i,j,l)= deltai
	     rt(i,j,l)=rho
	     if (deltai.lt.0.0d0) deltai=0.0d0
	     r(i,j,l)=(1.0-dexp(-2.0*deltai))**.5 
	    enddo
	  enddo
	enddo
c
	return
	end
	
	
	subroutine mvpacf(n,iklag,k,x,r)
c**********************************************************************
c
c   FORTRAN subroutine to calculate the partial autocorrelation 
c   function for a vector time series.
c
c   Input: n = an integer containing the number of observations in the
c              time series.
c          iklag = an integer containing the maximum lag for calculating
c                  the partial autocorrelation function.
c          k = an integer containing the number of time series in the
c              vector time series.
c          x = a double precision matrix of dimension n x k containing
c              the time series.
c   Output: r = a double precision real array of dimensions iklag x k x k
c               containing the partial autocorrelation function of x.
c
c   Subprograms called:
c
c   Created: 2/5/99 BKR
c   Modified: 2/10/99 BKR, 2/11/99 JLH
c
c**********************************************************************
	parameter (maxn=2000, maxk=5, maxlag=10)
  	implicit double precision (a-h, p-z)
	double precision x(maxn,maxk), r(maxlag,maxk,maxk)
	double precision y(maxn,maxk*(maxlag+1))
	double precision beta(maxk*(maxlag+1),maxk)
	double precision rm(maxk*(maxlag+1),maxk*(maxlag+1))
	double precision scpe1(maxk*(maxlag+1),maxk*(maxlag+1))
	double precision d(maxk*(maxlag+1)),xmin(maxk*(maxlag+1))
	double precision xmax(maxk*(maxlag+1))
	double precision scpe2(maxk*(maxlag+1),maxk*(maxlag+1))
	double precision u1(maxn,maxk),u2(maxn,maxk)
	integer inddep(maxk),indind(maxk*maxlag)


	do i = 2,iklag
c
c    Forward Regression
c      Set up response and predictors
c
		do j = 1,k
 			inddep(j) = j
			y(1:(n-i),j) = x((i+1):n,j) 
		enddo
		do l = 1,i-1
		do j = 1,k
			indind(k*(l-1)+j) = k*l+j
			y(1:(n-i),k*l+j) = x((l+1):(n-i+l),j) 
		enddo
		enddo 
		call DRGIVN(0,n-i,k*i,y,maxn,1,k*(i-1),indind,k,inddep,0,0,1, 
     +       100.0d0*DMACH(4),beta,maxk*(maxlag+1),rm,maxk*(maxlag+1),d,
     +	   irank,dfe,scpe1,maxk*(maxlag+1),nrmiss,xmin,xmax)
		scpe1 = scpe1/dble(n-k*i-k) 
c
c     Compute residuals:
c
		do l = 1,k
		do j = 1,n-i
			u1(j,l)=y(j,l)-beta(1,l)
			do m = 1,k*(i-1)
				u1(j,l) = u1(j,l) - beta(m+1,l)*y(j,indind(m))
			enddo
		enddo
		enddo
c	     
c  Backward Regression
c   Set up response ( predictors are same as for forward recursions):
c
		do j = 1,k
			y(1:(n-i),j) = x(1:(n-i),j) 
		enddo
		call DRGIVN(0,n-i,k*i,y,maxn,1,k*(i-1),indind,k,inddep,0,0,1, 
     +       100.0d0*DMACH(4),beta,maxk*(maxlag+1),rm,maxk*(maxlag+1),d,
     +       irank,dfe,scpe2,maxk*(maxlag+1),nrmiss,xmin,xmax)
		scpe2 = scpe2/dble(n-k*i-k) 
c
c     Compute residuals:
c
		do l = 1,k
		do j = 1,n-i
			u2(j,l) = y(j,l) - beta(1,l)
			do m = 1,k*(i-1)
				u2(j,l) = u2(j,l) - beta(m+1,l)*y(j,indind(m))
			enddo
		enddo
		enddo
c
c     Compute PACF from residuals series:
c
		do l = 1,k
			do m = 1,k
				do j = 1,n-i
					r(i,l,m) = r(i,l,m) + u1(j,l)*u2(j,m)
				enddo
				r(i,l,m) = r(i,l,m)/dble(n-i+1)
				r(i,l,m) = r(i,l,m)/dsqrt(scpe1(l,l)*scpe2(m,m))
			enddo
		enddo
c
      enddo
c
	return
	end
	

	subroutine vech(A,B,ndim,n,mdim,m,k,iopt,z)
c
c**********************************************************************
c
c   FORTRAN subroutine to calculate the stacking or half-stacking
c   vector of the product of two vectors.
c
c   Input: A = a double precision matrix of dimension n x m.
c          B = a double precision matrix of dimension m x k.
c          mdim = an integer containing the number of columns of A
c                 in the calling routine.
c          n = an integer containing the number of columns of A. 
c          mdim = an integer containing the number of columns of B
c                 in the calling routine.
c          m = an integer containing the number of rows of A and
c              the number of columns of B.
c          k = an integer containing the number of rows of B.
c          iopt = an integer indicating whether to take the half-
c                 stacking vector (iopt = 0) or the stacking vector
c                 (iopt = 1).
c
c   Output: z = a double precision vector containing the half-stacking
c               or stacking vector of A and B.  If iopt = 0, the 
c               length of y is (nk)[(nk)+1]/2.  If iopt = 1, the 
c               length of z is nk.
c
c   Accuracy: Implicit double precision.
c
c   Created: 7/19/97 Bonnie Ray
c   Modified: 7/23/97 Jane L. Harvill
c
c   Subprograms called: none.
c
c**********************************************************************
c
	parameter (nkmx = 5, npmx = 10)
	parameter (nqmx = (npmx*nkmx)**2)
c
	integer n,k,iopt,indexz
c
	double precision A(npmx*nkmx),B(1,npmx*nkmx)
	double precision z(nqmx)
c
c   Initialize z:
c
	do i = 1,nqmx
		z(i) = 0.0d0
	enddo
c
c   Calculate element by element product of the matrices A and B and
c   place result in vector z.
c
	llim = 1
	indexz = 0
c
     	do i = 1,k
	if(iopt.eq.0) llim = i
		do j = llim,n
			indexz = indexz + 1
			z(indexz)= A(j)*B(1,i)
 		enddo
	enddo
c
	return
	end

	subroutine kbivar(n,x,y,xt,yt,rho,f)
	parameter(maxn=2000)
  	implicit double precision (a-h,p-z)
	double precision xt(maxn),yt(maxn)
c
	hx=.85*(1.0-rho**2.)**(5./12.)*(1+rho**2./2.)**(-1./6.)
     + *dble(n)**(-1./6.)
	hy=hx
c   ********   For testing
c	hx=.85*dble(n)**(-1./6.) 
c	hy=hx
c   ***********
	f=0.0
	do i=1,n
	   f=f+dtpdf((x-xt(i))/hx)*dtpdf((y-yt(i))/hy) 
	enddo
	f=f/(dble(n)*hx*hy)
c
	return
	end
c
	subroutine kuniv(n,x,xt,f)
	parameter(maxn=2000)
  	implicit double precision (a-h,p-z)
	double precision xt(maxn)
c
	hx=.85*dble(n)**(-1./5.) 
	f=0.0
	do i=1,n
	   f=f+dtpdf((x-xt(i))/hx) 
	enddo
	f=f/(dble(n)*hx)
c
	return
	end
c
	double precision function dnorm(x)
	implicit double precision (a-h,p-z)
c
      pi=4.0d0*datan(1.0d0)
c
	dnorm=dexp(-.5d0*(x**2.0d0))
	dnorm=dnorm/dsqrt(2.0d0*pi)
c
	return
	end
c
	double precision function dtpdf(x)
	implicit double precision (a-h,p-z)
	parameter(df=4.0d0)
c
      pi=4.0d0*datan(1.0d0)
c
	dtpdf=(1.0d0+x**2.0d0/df)**(-(df+1.0d0)/2.0d0)
	dtpdf=dtpdf/dsqrt(pi*df)
	dtpdf=dtpdf*DGAMMA((df+1.0d0)/2.0d0)*DGAMR(df/2.0d0)
c
	return
	end
c
	subroutine hbivar2(in,n,xt,yt,h,rho)
	parameter(maxn=2000,inmx=30)
  	implicit double precision (a-h,p-z)
	double precision xt(maxn),yt(maxn)
	double precision qx(inmx),qwx(inmx),fx(inmx),fy(inmx) 
	double precision xts(maxn),xlow(2),xupp(2) 
c
	rho=0.0d0
	do i=1,n
	   rho=rho+xt(i)*yt(i)
	enddo
	rho=rho/dble(n) 
c     Find max and min of xt and yt 
	CALL DSVRGN (N, xt, xts)
	xlow(1)=xts(1) 
	xupp(1)=xts(n) 
 	CALL DSVRGN (N, yt, xts)
	xlow(2)=xts(1) 
	xupp(2)=xts(n) 
	ndim=2
      CALL DGQRUL (in,1,0.0d0,0.0d0,0,QXFIX,QX,QWX)
	do i=1,in
         tempx=qx(i)*(xupp(1)-xlow(1)+2.)/2.0+(xupp(1)+xlow(1))/2.0
         tempy=qx(i)*(xupp(2)-xlow(2)+2.)/2.0+(xupp(2)+xlow(2))/2.0
         call kuniv(n,tempx,xt,fx(i))
         call kuniv(n,tempy,yt,fy(i))
	enddo
	h=0.0d0
	do i=1,in
	   do j=1,in
         tempx=qx(i)*(xupp(1)-xlow(1)+2.)/2.0+(xupp(1)+xlow(1))/2.0
         tempy=qx(j)*(xupp(2)-xlow(2)+2.)/2.0+(xupp(2)+xlow(2))/2.0
         call kbivar(n,tempx,tempy,xt,yt,rho,f)
         h=h+(dlog(f)-dlog(fx(i))-dlog(fy(j)))*f*qwx(i)*qwx(j)
	   enddo
	enddo
	h=h*(xupp(1)-xlow(1)+2.)*(xupp(2)-xlow(2)+2.)/4.d0
c	
      return
	end    	  
